<?php
$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
$custom_menus = array(
    '' => esc_html__('Default', 'bixol')
);
if ( is_array( $menus ) && ! empty( $menus ) ) {
    foreach ( $menus as $single_menu ) {
        if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
            $custom_menus[ $single_menu->slug ] = $single_menu->name;
        }
    }
} else {
    $custom_menus = '';
}
ct_add_custom_widget(
    array(
        'name' => 'ct_menu',
        'title' => esc_html__('Case Nav Menu', 'bixol'),
        'icon' => 'eicon-nav-menu',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => [
            'ct-inline-css-js',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source Settings', 'bixol'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'menu',
                            'label' => esc_html__('Select Menu', 'bixol'),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => $custom_menus,
                        ),
                        array(
                            'name' => 'style_l1',
                            'label' => esc_html__('Style', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style-default' => 'Default',
                            ],
                            'default' => 'style-default',
                        ),
                        array(
                            'name' => 'align',
                            'label' => esc_html__('Alignment', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__('Left', 'bixol' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'bixol' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'bixol' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu' => 'text-align: {{VALUE}};',
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu > li' => 'float: none;',
                            ],
                        ),
                        array(
                            'name' => 'menu_bg_color',
                            'label' => esc_html__('Menu Box Color', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu1.style1' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'style_l1' => ['style1'],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'first_section',
                    'label' => esc_html__('Style First Level', 'bixol'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'hover_active_style',
                            'label' => esc_html__('Item Hover/Active Style', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'hv-style1' => 'Default',
                            ],
                            'default' => 'hv-style1',
                            'condition' => [
                                'style_l1' => ['style1'],
                            ],
                        ),
                        array(
                            'name' => 'divider_color',
                            'label' => esc_html__('Color Divider', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu1.hv-style3 .ct-main-menu > li > a .ct-menu--line::before, {{WRAPPER}} .ct-nav-menu1.hv-style3 .ct-main-menu > li > a .ct-menu--line::after' => 'background-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'hover_active_style' => ['hv-style3'],
                            ],
                        ),
                        array(
                            'name' => 'color',
                            'label' => esc_html__('Color', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu > li > a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .ct-nav-menu1 .ct-menu--plus::before, {{WRAPPER}} .ct-nav-menu1 .ct-menu--plus::after' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'color_hover',
                            'label' => esc_html__('Color Hover', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu > li > a:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'color_active',
                            'label' => esc_html__('Color Active', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu > li.current-menu-parent > a, {{WRAPPER}} .ct-nav-menu .ct-main-menu > li.current_page_item > a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'line_color_gr_from',
                            'label' => esc_html__('Divider Gradient Color From', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'style_l1' => ['style2', 'style3'],
                            ],
                        ),
                        array(
                            'name' => 'line_color_gr_to',
                            'label' => esc_html__('Divider Gradient Color To', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'style_l1' => ['style2', 'style3'],
                            ],
                        ),
                        array(
                            'name' => 'line_height',
                            'label' => esc_html__('Divider Height', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu1.style2 .ct-main-menu > li > a::before, {{WRAPPER}} .ct-nav-menu1.style3 .ct-main-menu > li > a::before' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'style_l1' => ['style2', 'style3'],
                            ],
                        ),
                        array(
                            'name' => 'typography',
                            'label' => esc_html__('Typography', 'bixol' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .ct-nav-menu .ct-main-menu > li > a',
                        ),
                        array(
                            'name' => 'item_space',
                            'label' => esc_html__('Item Space', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%', 'rem' ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'sub_section',
                    'label' => esc_html__('Style Sub Level', 'bixol'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'mega_fullwidth',
                            'label' => esc_html__('Mega Menu Full Width', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'no' => 'No',
                                'yes' => 'Yes',
                            ],
                            'default' => 'no',
                        ),
                        array(
                            'name' => 'sub_color',
                            'label' => esc_html__('Color', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu li > a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'sub_color_hover',
                            'label' => esc_html__('Color Hover/Actvie', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu li:hover > a, {{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu li.current_page_item > a, {{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu li.current-menu-item > a, {{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu li.current_page_ancestor > a, {{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu li.current-menu-ancestor > a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'sub_typography',
                            'label' => esc_html__('Typography', 'bixol' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu a',
                        ),
                        array(
                            'name' => 'sub_border_radius',
                            'label' => esc_html__('Box Border Radius', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%', 'rem' ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-nav-menu .ct-main-menu li .sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);